using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgExceptionReportCriteria
	/// </summary>
	public class DlgExceptionReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Variables
		private Form _mdiParent;
		private int _recordCount;
		BOL.ExceptionReport exceptionReport;
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="mdiParent"></param>
		public DlgExceptionReportCriteria(Form mdiParent)
		{
			// This call is required by the Windows Form Designer.
			exceptionReport=new gov.va.med.vbecs.BOL.ExceptionReport();
			this.exceptionReport.Valid += new System.EventHandler(this.CheckValid);
			this.exceptionReport.Invalid += new System.EventHandler(this.CheckValid);
			this.exceptionReport.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this.exceptionReport.DivisionCode = Common.LogonUser.LogonUserDivisionCode;

			InitializeComponent();
			SetComponentProperties();
			_mdiParent = mdiParent;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgExceptionReportCriteria));
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(398, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Exception Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 235);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 84);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(332, 125);
			this.grpReportCompilation.TabIndex = 1;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 44);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 44);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(316, 73);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			this.grpScheduleJob.Text = "grpScheduleJob";
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(212, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(212, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(332, 48);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(168, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(224, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(236, 215);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.HoverOK);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(316, 215);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 177);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// DlgExceptionReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(398, 251);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpDateRange);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Exception_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(404, 276);
			this.Name = "DlgExceptionReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Exception Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get/Set StartDate
		/// </summary>
		public DateTime StartDate
		{
			get
			{
				DateTime startDate = new DateTime(this.dtpStartDate.Value.Year,
												  this.dtpStartDate.Value.Month,
												  this.dtpStartDate.Value.Day,
												  0,
												  0,
												  0);
				return startDate;
			}
			set
			{
				this.dtpStartDate.Value = value;
			}
		}

		/// <summary>
		/// Get/Set EndDate
		/// </summary>
		public DateTime EndDate
		{
			get
			{
				DateTime endDate = new DateTime(this.dtpEndDate.Value.Year,
												this.dtpEndDate.Value.Month,
												this.dtpEndDate.Value.Day,
												23,
												59,
												59);
				return endDate;
			}
			set
			{
				this.dtpEndDate.Value = value;
			}
		}

		#endregion

		#region Events / Event Handlers

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.exceptionReport.StartDate = this.dtpStartDate.Value;
			//
			CheckDates();
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.exceptionReport.EndDate = this.dtpEndDate.Value;
			//
			CheckDates();
		}

		private void CheckDates()
		{
			if (this.exceptionReport.StartDate > this.exceptionReport.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate, Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date", "End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this.exceptionReport.IsScheduled)
			{
				if (this.exceptionReport.EndDate > this.exceptionReport.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date", "End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			// Schedule the report to print
			if(this.rdoScheduleJob.Checked)
			{
				exceptionReport.IsScheduled=true;
				exceptionReport.DivisionCode=Common.LogonUser.LogonUserDivisionCode;
				exceptionReport.StartDate=this.dtpStartDate.Value; 
				exceptionReport.EndDate=this.dtpEndDate.Value; 
				exceptionReport.PrintedBy=Common.LogonUser.LogonUserName;
				exceptionReport.PrintDate=this.dtpPrintDate.Value; 
                //CR 3333
				exceptionReport.PrinterName=this.cmbPrinterName.Text;

				exceptionReport.Schedule();
			}
			else
			{
				Hashtable exceptionReports = null;

				using( WaitCursor _cursor = new WaitCursor() )
				{
					exceptionReports = this.LoadExceptionReport(this.StartDate, this.EndDate);
				}

				if (_recordCount == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC082.NoExceptionsFound());
				}
				else
				{
					FrmExceptionReport frm = new FrmExceptionReport(this.StartDate, this.EndDate, exceptionReports);
					frm.MdiParent = this._mdiParent;
					frm.Show();
				}
			}
		}
		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC082.DlgExceptionReportCriteria());
			//
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());

			//set custom date and time format
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateFormat;

			this.dtpStartDate.Value = this.exceptionReport.StartDate;
			this.dtpEndDate.Value = this.exceptionReport.EndDate;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpPrintDate.Value = _currentDate;

			this.LoadPrinters();
		}

		/// <summary>
		/// Loads exception report data
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		private Hashtable LoadExceptionReport(DateTime startDate, DateTime endDate)
		{
			Hashtable exceptionReports = new Hashtable();

			DataSet dsExceptionReportQC = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportQC);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportQC, dsExceptionReportQC);

			DataSet dsExceptionReportQCInactivated = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportQCInactivated);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportQCInactivated, dsExceptionReportQCInactivated);

			DataSet dsExceptionReportQCNotPerformed = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportQCNotPerformed);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportQCNotPerformed, dsExceptionReportQCNotPerformed);

			DataSet dsExceptionReportQuarantine = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportQuarantine);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportQuarantine, dsExceptionReportQuarantine);

			DataSet dsExceptionReportReflexTest = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportReflexTest);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportReflexTest, dsExceptionReportReflexTest);

			DataSet dsExceptionReportSpecimen = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportSpecimen);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportSpecimen, dsExceptionReportSpecimen);

			DataSet dsExceptionReportPatientAboRh = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportPatientAboRh);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportPatientAboRh, dsExceptionReportPatientAboRh);

			DataSet dsExceptionReportPatientAboRhDiscrepancy = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy, dsExceptionReportPatientAboRhDiscrepancy);

			DataSet dsExceptionReportPatientAntigenDiscrepancy = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy, dsExceptionReportPatientAntigenDiscrepancy);

			DataSet dsExceptionReportPatientTest = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportPatientTest);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportPatientTest, dsExceptionReportPatientTest);

			DataSet dsExceptionReportPatientTestInactivated = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportPatientTestInactivated);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportPatientTestInactivated, dsExceptionReportPatientTestInactivated);

			DataSet dsExceptionReportUnitAboRh = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitAboRh);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitAboRh, dsExceptionReportUnitAboRh);

			DataSet dsExceptionReportUnitModification = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitModification);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitModification, dsExceptionReportUnitModification);

			DataSet dsExceptionReportUnitSelection = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitSelection);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitSelection, dsExceptionReportUnitSelection);

			DataSet dsExceptionReportLabelMismatch = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportLabelMismatch);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportLabelMismatch, dsExceptionReportLabelMismatch);

			DataSet dsExceptionReportCautionTagBTRFPrinting = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting, dsExceptionReportCautionTagBTRFPrinting);

			DataSet dsExceptionReportTrwSpecimen = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportTrwSpecimen);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportTrwSpecimen, dsExceptionReportTrwSpecimen);

			DataSet dsExceptionReportTransfusionReactionWorkup = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup, dsExceptionReportTransfusionReactionWorkup);

			DataSet dsExceptionReportAntigenTest = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportAntigenTest);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportAntigenTest, dsExceptionReportAntigenTest);

			DataSet dsExceptionReportUnitTest = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitTest);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitTest, dsExceptionReportUnitTest);

			DataSet dsExceptionReportReturnIssuedUnit = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportReturnIssuedUnit);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportReturnIssuedUnit, dsExceptionReportReturnIssuedUnit);

			DataSet dsExceptionReportTransfusion = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportTransfusion);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportTransfusion, dsExceptionReportTransfusion);

			DataSet dsExceptionReportExpiredUnit = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportExpiredUnitReceived);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportExpiredUnitReceived, dsExceptionReportExpiredUnit);

			DataSet dsExceptionReportUnitSupply = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitSupply);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitSupply, dsExceptionReportUnitSupply);

			DataSet dsExceptionReportUnitIssue = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitIssue);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitIssue, dsExceptionReportUnitIssue);

			DataSet dsExceptionReportPatientRestriction = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportPatientRestriction);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportPatientRestriction, dsExceptionReportPatientRestriction);

			DataSet dsExceptionReportEmergencyIssueOrder = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder, dsExceptionReportEmergencyIssueOrder);

			DataSet dsExceptionReportEmergencyIssueUnitTest = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem, dsExceptionReportEmergencyIssueUnitTest);

			DataSet dsExceptionReportExpiredOrder = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportExpiredTaskProcessed);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportExpiredTaskProcessed, dsExceptionReportExpiredOrder);

			DataSet dsExceptionReportRemoveFinalUnitStatus = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus, dsExceptionReportRemoveFinalUnitStatus);

			DataSet dsExceptionReportInconclusiveCrossmatch = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportCrossmatch);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportCrossmatch,  dsExceptionReportInconclusiveCrossmatch);

			// CR 2942
			DataSet dsExceptionReportElectronicTransfusion = BOL.ExceptionReport.GetExceptionReport(startDate, endDate, Common.ExceptionReportType.ExceptionReportElectronicTransfusion);
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportElectronicTransfusion, dsExceptionReportElectronicTransfusion);
			
			DataSet dsExceptionReportMain = BOL.ExceptionReport.GetExceptionReportMain();
			exceptionReports.Add(Common.ExceptionReportType.ExceptionReportMain, dsExceptionReportMain);
/*
            dsExceptionReportQC.WriteXml("e:\\temp\\ExceptionQCDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportQCInactivated.WriteXml("e:\\temp\\ExceptionQCInactivatedDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportQCNotPerformed.WriteXml("e:\\temp\\ExceptionQCNotPerformedDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportEmergencyIssueOrder.WriteXml("e:\\temp\\ExceptionEmergencyIssueOrderDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportQuarantine.WriteXml("e:\\temp\\ExceptionQuarantineDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportReflexTest.WriteXml("e:\\temp\\ExceptionReflexTestDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportSpecimen.WriteXml("e:\\temp\\ExceptionSpecimenDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportPatientAboRh.WriteXml("e:\\temp\\ExceptionPatientAboRhDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportPatientAboRhDiscrepancy.WriteXml("e:\\temp\\ExceptionPatientAboRhDiscrepancyDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportPatientAntigenDiscrepancy.WriteXml("e:\\temp\\ExceptionPatientAntigenDiscrepancyDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportPatientTest.WriteXml("e:\\temp\\ExceptionPatientTestDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportPatientTestInactivated.WriteXml("e:\\temp\\ExceptionPatientTestInactivatedDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportUnitAboRh.WriteXml("e:\\temp\\ExceptionUnitAboRhDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportUnitModification.WriteXml("e:\\temp\\ExceptionUnitModificationDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportUnitSelection.WriteXml("e:\\temp\\ExceptionUnitSelectionDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportLabelMismatch.WriteXml("e:\\temp\\ExceptionLabelMismatchDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportCautionTagBTRFPrinting.WriteXml("e:\\temp\\ExceptionCautionTagBTRFPrintingDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportTrwSpecimen.WriteXml("e:\\temp\\ExceptionTrwSpecimenDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportTransfusionReactionWorkup.WriteXml("e:\\temp\\ExceptionTransfusionReactionWorkupDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportAntigenTest.WriteXml("e:\\temp\\ExceptionAntigenTestDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportUnitTest.WriteXml("e:\\temp\\ExceptionUnitTestDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportReturnIssuedUnit.WriteXml("e:\\temp\\ExceptionReturnIssuedUnitDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportTransfusion.WriteXml("e:\\temp\\ExceptionTransfusionDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportUnitSupply.WriteXml("e:\\temp\\ExceptionUnitSupplyDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportExpiredUnit.WriteXml("e:\\temp\\ExceptionExpiredUnitDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportUnitIssue.WriteXml("e:\\temp\\ExceptionUnitIssueDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportPatientRestriction.WriteXml("e:\\temp\\ExceptionPatientRestrictionDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportEmergencyIssueUnitTest.WriteXml("e:\\temp\\ExceptionEmergencyIssueUnitTestDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportExpiredOrder.WriteXml("e:\\temp\\ExceptionExpiredOrderDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportRemoveFinalUnitStatus.WriteXml("e:\\temp\\ExceptionRemoveFinalUnitStatusDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportInconclusiveCrossmatch.WriteXml("e:\\temp\\ExceptionInconclusiveCrossmatchDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportElectronicTransfusion.WriteXml("e:\\temp\\ExceptionElectronicTransfusionDataSet.xml", XmlWriteMode.WriteSchema);
            dsExceptionReportMain.WriteXml("e:\\temp\\ExceptionMainDataSet.xml", XmlWriteMode.WriteSchema);
            */
            _recordCount = 0;

			
			if (dsExceptionReportQC.Tables.Count > 0)
			{
				if (dsExceptionReportQC.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportQC.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQc.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQc.TableName + "Suppress"] = true;
				}
			}
			
			
			if (dsExceptionReportQCInactivated.Tables.Count > 0)
			{
				if (dsExceptionReportQCInactivated.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportQCInactivated.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQcInactivation.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQcInactivation.TableName + "Suppress"] = true;
				}
			}
			if (dsExceptionReportQCNotPerformed.Tables.Count > 0)
			{
				if (dsExceptionReportQCNotPerformed.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportQCNotPerformed.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQcNotPerformed.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQcNotPerformed.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportQuarantine.Tables.Count > 0)
			{
				if (dsExceptionReportQuarantine.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportQuarantine.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQuarantine.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionQuarantine.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportReflexTest.Tables.Count > 0)
			{
				if (dsExceptionReportReflexTest.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportReflexTest.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionReflexTest.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionReflexTest.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportSpecimen.Tables.Count > 0)
			{
				if (dsExceptionReportSpecimen.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportSpecimen.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionSpecimen.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionSpecimen.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportPatientAboRh.Tables.Count > 0)
			{
				if (dsExceptionReportPatientAboRh.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportPatientAboRh.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientAboRh.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientAboRh.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportPatientAboRhDiscrepancy.Tables.Count > 0)
			{
				if (dsExceptionReportPatientAboRhDiscrepancy.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportPatientAboRhDiscrepancy.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientAboRhDiscrepancy.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientAboRhDiscrepancy.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportPatientTest.Tables.Count > 0)
			{
				if (dsExceptionReportPatientTest.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportPatientTest.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientTest.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientTest.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportPatientTestInactivated.Tables.Count > 0)
			{
				if (dsExceptionReportPatientTestInactivated.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportPatientTestInactivated.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientTestInactivated.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientTestInactivated.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportUnitAboRh.Tables.Count > 0)
			{
				if (dsExceptionReportUnitAboRh.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportUnitAboRh.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitAboRh.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitAboRh.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportPatientAntigenDiscrepancy.Tables.Count > 0)
			{
				if (dsExceptionReportPatientAntigenDiscrepancy.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportPatientAntigenDiscrepancy.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientAntigenDiscrepancy.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientAntigenDiscrepancy.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportUnitModification.Tables.Count > 0)
			{
				if (dsExceptionReportUnitModification.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportUnitModification.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitModification.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitModification.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportUnitSelection.Tables.Count > 0)
			{
				if (dsExceptionReportUnitSelection.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportUnitSelection.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitSelection.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitSelection.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportLabelMismatch.Tables.Count > 0)
			{
				if (dsExceptionReportLabelMismatch.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportLabelMismatch.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionLabelMismatch.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionLabelMismatch.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportCautionTagBTRFPrinting.Tables.Count > 0)
			{
				if (dsExceptionReportCautionTagBTRFPrinting.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportCautionTagBTRFPrinting.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionCautionTag.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionCautionTag.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportTrwSpecimen.Tables.Count > 0)
			{
				if (dsExceptionReportTrwSpecimen.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportTrwSpecimen.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionTrwSpecimen.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionTrwSpecimen.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportTransfusionReactionWorkup.Tables.Count > 0)
			{
				if (dsExceptionReportTransfusionReactionWorkup.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportTransfusionReactionWorkup.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionTransfusionReactionWorkup.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionTransfusionReactionWorkup.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportAntigenTest.Tables.Count > 0)
			{
				if (dsExceptionReportAntigenTest.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportAntigenTest.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionAntigenTest.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionAntigenTest.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportUnitTest.Tables.Count > 0)
			{
				if (dsExceptionReportUnitTest.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportUnitTest.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0]["ExceptionUnitTestSuppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0]["ExceptionUnitTestSuppress"] = true;
				}
			}

			if (dsExceptionReportReturnIssuedUnit.Tables.Count > 0)
			{
				if (dsExceptionReportReturnIssuedUnit.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportReturnIssuedUnit.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionReturnedUnit.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionReturnedUnit.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportTransfusion.Tables.Count > 0)
			{
				if (dsExceptionReportTransfusion.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportTransfusion.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionTransfusion.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionTransfusion.TableName + "Suppress"] = true;
				}
			}
			
			if (dsExceptionReportExpiredUnit.Tables.Count > 0)
			{
				if (dsExceptionReportExpiredUnit.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportExpiredUnit.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionExpiredUnitReceived.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionExpiredUnitReceived.TableName + "Suppress"] = true;
				}
			}
		
			if (dsExceptionReportUnitSupply.Tables.Count > 0)
			{
				if (dsExceptionReportUnitSupply.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportUnitSupply.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0]["ExceptionReportUnitSupplySuppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0]["ExceptionReportUnitSupplySuppress"] = true;
				}
			}

			if (dsExceptionReportEmergencyIssueOrder.Tables.Count > 0)
			{
				if (dsExceptionReportEmergencyIssueOrder.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportEmergencyIssueOrder.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0]["ExceptionEmergencyIssueOrderSuppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0]["ExceptionEmergencyIssueOrderSuppress"] = true;
				}
			}
			
			if (dsExceptionReportUnitIssue.Tables.Count > 0)
			{
				if (dsExceptionReportUnitIssue.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportUnitIssue.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitIssue.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionUnitIssue.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportPatientRestriction.Tables.Count > 0)
			{
				if (dsExceptionReportPatientRestriction.Tables[0].Rows.Count > 0)
				{
                    _recordCount += dsExceptionReportPatientRestriction.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientRestriction.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionPatientRestriction.TableName + "Suppress"] = true;
				}
			}
			
			if (dsExceptionReportEmergencyIssueUnitTest.Tables.Count > 0)
			{
				if (dsExceptionReportEmergencyIssueUnitTest.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportEmergencyIssueUnitTest.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionEmergencyIssueUnitTest.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionEmergencyIssueUnitTest.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportExpiredOrder.Tables.Count > 0)
			{
				if (dsExceptionReportExpiredOrder.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportExpiredOrder.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionExpiredTask.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionExpiredTask.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportRemoveFinalUnitStatus.Tables.Count > 0)
			{
				if (dsExceptionReportRemoveFinalUnitStatus.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportRemoveFinalUnitStatus.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionRemoveFinalUnitStatus.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionRemoveFinalUnitStatus.TableName + "Suppress"] = true;
				}
			}

			if (dsExceptionReportInconclusiveCrossmatch.Tables.Count > 0)
			{
				if (dsExceptionReportInconclusiveCrossmatch.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportInconclusiveCrossmatch.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionInconclusiveCrossmatch.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionInconclusiveCrossmatch.TableName + "Suppress"] = true;
				}
			}

			//CR 2942
			if (dsExceptionReportElectronicTransfusion.Tables.Count > 0)
			{
				if (dsExceptionReportElectronicTransfusion.Tables[0].Rows.Count > 0)
				{
					_recordCount += dsExceptionReportElectronicTransfusion.Tables[0].Rows.Count;
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionElectronicTransfusion.TableName + "Suppress"] = false;
				}
				else
				{
					dsExceptionReportMain.Tables[0].Rows[0][Common.VbecsTables.ExceptionElectronicTransfusion.TableName + "Suppress"] = true;
				}
			}

			return exceptionReports;
		}

		#endregion

		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpScheduleJob.Enabled=this.rdoScheduleJob.Checked; 
			this.exceptionReport.IsScheduled=this.rdoScheduleJob.Checked;
			if ((this.exceptionReport.IsScheduled) && (this.exceptionReport.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (this.exceptionReport.IsScheduled)
			{
				this.exceptionReport.PrintDate = this.dtpPrintDate.Value;
			}
			//
			CheckDates(); 
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this.exceptionReport.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this.exceptionReport.PrinterName=String.Empty;
			}
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton=(this.exceptionReport.IsValid);
		}

		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this.exceptionReport.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this.exceptionReport.GetBrokenRulesMessage(gov.va.med.vbecs.Common.VbecsBrokenRules.InappropriateTransfusionRequestReport.FormClassName));
			}
		}
	}
}

